$(function() {
	/* 禁止文本选择 */
	document.onselectstart = new Function("return false");
	document.ondragstart = new Function("return false");

	$(document.body).bind('keydown', function() {		
		if(event.keyCode == 65 && event.ctrlKey) {
			event.preventDefault();
		}
	});	
	
	// 设置close-button的淡入淡出
	$('#close-button').append('<span class="hover"></span>').hover(function() {
		if(!$(this).is('.close-button-disabled')) {
			view.fadeButtonIn.apply(this);
		}
	}, function() {
		if(!$(this).is('.close-button-disabled')) {
			var el = this;
			
			setTimeout(function() {
				if (!el.open) view.fadeButtonOut.apply(el);
			}, 10);
		}
	}).click(function() {
		if(!$(this).is('.close-button-disabled')) {
			qqbrowser.dialog.close(0); // 关闭页面
		}
	}).mousedown(function() {
		if(!$(this).is('.close-button-disabled')) {
			$(this).addClass('close-button-pressed');
			return false;
		}
	}).mouseup(function() {
		if(!$(this).is('.close-button-disabled')) {
			$(this).removeClass('close-button-pressed');
		}
	}); 

	$('#close-bottom-button').click(function() {
		qqbrowser.dialog.close(0); // 关闭页面
	});

	popupFrame.init();

	//.html??title=abc&width=400&height=300

	//qqbrowser.dialog.resize(x,y,width,height)	
});

var popupFrame = {};

popupFrame.init = function() {
	popupFrame.setTitle(popupFrame.getTitle());

	var popupFrameHeight = popupFrame.getHeight();

	$('#popup').height(popupFrameHeight).width(popupFrame.getWidth());

	var configBody = $('#config-body');
	var popupHeader = $('#popup-header');

	var popupFrameBorderWidth = view.getBorderWidth('popup');

	configBody.height(popupFrameHeight - popupHeader.outerHeight() - popupFrameBorderWidth.top - popupFrameBorderWidth.bottom - 1);
		
	browser.dialog.resize(configBody.offset().left, configBody.offset().top, configBody.width(), configBody.height());

	// 点击标题栏调用拖拽
	popupHeader.mousedown(function() {
		try {
			browser.skin.dragStart(5);
		} catch(e) {
//			alert(1);
		}
	});
};

popupFrame.setTitle = function(title) {
	$('#title').html(title);
};

popupFrame.setCloseButtonEnabled = function() {
	$('#close-button').removeClass('close-button-disabled');
};

popupFrame.setCloseButtonDisabled = function() {
	$('#close-button').addClass('close-button-disabled');
};

popupFrame.getTitle = function() {
	return unescape(utils.parseUrl().title);
};

popupFrame.getWidth = function() {
	return parseInt(utils.parseUrl().width);
};

popupFrame.getHeight = function() {
	return parseInt(utils.parseUrl().height);
};


qqbrowser.dialog.onSetButtonStatus.addListener(function(id, nStatus) {
	if(id == 0) { // 关闭按钮
		if(nStatus == 0) { // enable
			popupFrame.setCloseButtonEnabled();
		} else if(nStatus == 1) { // disable
			popupFrame.setCloseButtonDisabled();
		}
	}
});

qqbrowser.dialog.onSetTitle.addListener(function(strTitle) {
	popupFrame.setTitle(strTitle);
}); 